"""Generated client library for dialogflow version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.dialogflow.v2 import dialogflow_v2_messages as messages


class DialogflowV2(base_api.BaseApiClient):
  """Generated client library for service dialogflow version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://dialogflow.googleapis.com/'
  MTLS_BASE_URL = 'https://dialogflow.mtls.googleapis.com/'

  _PACKAGE = 'dialogflow'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/dialogflow']
  _VERSION = 'v2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'DialogflowV2'
  _URL_VERSION = 'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new dialogflow handle."""
    url = url or self.BASE_URL
    super(DialogflowV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_agent_entityTypes_entities = self.ProjectsAgentEntityTypesEntitiesService(self)
    self.projects_agent_entityTypes = self.ProjectsAgentEntityTypesService(self)
    self.projects_agent_environments_users_sessions_contexts = self.ProjectsAgentEnvironmentsUsersSessionsContextsService(self)
    self.projects_agent_environments_users_sessions_entityTypes = self.ProjectsAgentEnvironmentsUsersSessionsEntityTypesService(self)
    self.projects_agent_environments_users_sessions = self.ProjectsAgentEnvironmentsUsersSessionsService(self)
    self.projects_agent_environments_users = self.ProjectsAgentEnvironmentsUsersService(self)
    self.projects_agent_environments = self.ProjectsAgentEnvironmentsService(self)
    self.projects_agent_intents = self.ProjectsAgentIntentsService(self)
    self.projects_agent_sessions_contexts = self.ProjectsAgentSessionsContextsService(self)
    self.projects_agent_sessions_entityTypes = self.ProjectsAgentSessionsEntityTypesService(self)
    self.projects_agent_sessions = self.ProjectsAgentSessionsService(self)
    self.projects_agent = self.ProjectsAgentService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_operations = self.ProjectsOperationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsAgentEntityTypesEntitiesService(base_api.BaseApiService):
    """Service class for the projects_agent_entityTypes_entities resource."""

    _NAME = 'projects_agent_entityTypes_entities'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentEntityTypesEntitiesService, self).__init__(client)
      self._upload_configs = {
          }

    def BatchCreate(self, request, global_params=None):
      r"""Creates multiple new entities in the specified entity type.

Operation <response: google.protobuf.Empty>

      Args:
        request: (DialogflowProjectsAgentEntityTypesEntitiesBatchCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('BatchCreate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchCreate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchCreate',
        http_method='POST',
        method_id='dialogflow.projects.agent.entityTypes.entities.batchCreate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/entities:batchCreate',
        request_field='googleCloudDialogflowV2BatchCreateEntitiesRequest',
        request_type_name='DialogflowProjectsAgentEntityTypesEntitiesBatchCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def BatchDelete(self, request, global_params=None):
      r"""Deletes entities in the specified entity type.


Operation <response: google.protobuf.Empty>

      Args:
        request: (DialogflowProjectsAgentEntityTypesEntitiesBatchDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('BatchDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchDelete',
        http_method='POST',
        method_id='dialogflow.projects.agent.entityTypes.entities.batchDelete',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/entities:batchDelete',
        request_field='googleCloudDialogflowV2BatchDeleteEntitiesRequest',
        request_type_name='DialogflowProjectsAgentEntityTypesEntitiesBatchDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def BatchUpdate(self, request, global_params=None):
      r"""Updates or creates multiple entities in the specified entity type. This.
method does not affect entities in the entity type that aren't explicitly
specified in the request.


Operation <response: google.protobuf.Empty>

      Args:
        request: (DialogflowProjectsAgentEntityTypesEntitiesBatchUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('BatchUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchUpdate',
        http_method='POST',
        method_id='dialogflow.projects.agent.entityTypes.entities.batchUpdate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/entities:batchUpdate',
        request_field='googleCloudDialogflowV2BatchUpdateEntitiesRequest',
        request_type_name='DialogflowProjectsAgentEntityTypesEntitiesBatchUpdateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class ProjectsAgentEntityTypesService(base_api.BaseApiService):
    """Service class for the projects_agent_entityTypes resource."""

    _NAME = 'projects_agent_entityTypes'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentEntityTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def BatchDelete(self, request, global_params=None):
      r"""Deletes entity types in the specified agent.

Operation <response: google.protobuf.Empty>

      Args:
        request: (DialogflowProjectsAgentEntityTypesBatchDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('BatchDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes:batchDelete',
        http_method='POST',
        method_id='dialogflow.projects.agent.entityTypes.batchDelete',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/entityTypes:batchDelete',
        request_field='googleCloudDialogflowV2BatchDeleteEntityTypesRequest',
        request_type_name='DialogflowProjectsAgentEntityTypesBatchDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def BatchUpdate(self, request, global_params=None):
      r"""Updates/Creates multiple entity types in the specified agent.

Operation <response: BatchUpdateEntityTypesResponse>

      Args:
        request: (DialogflowProjectsAgentEntityTypesBatchUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('BatchUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes:batchUpdate',
        http_method='POST',
        method_id='dialogflow.projects.agent.entityTypes.batchUpdate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/entityTypes:batchUpdate',
        request_field='googleCloudDialogflowV2BatchUpdateEntityTypesRequest',
        request_type_name='DialogflowProjectsAgentEntityTypesBatchUpdateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates an entity type in the specified agent.

      Args:
        request: (DialogflowProjectsAgentEntityTypesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2EntityType) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes',
        http_method='POST',
        method_id='dialogflow.projects.agent.entityTypes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['languageCode'],
        relative_path='v2/{+parent}/entityTypes',
        request_field='googleCloudDialogflowV2EntityType',
        request_type_name='DialogflowProjectsAgentEntityTypesCreateRequest',
        response_type_name='GoogleCloudDialogflowV2EntityType',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified entity type.

      Args:
        request: (DialogflowProjectsAgentEntityTypesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.entityTypes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentEntityTypesDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified entity type.

      Args:
        request: (DialogflowProjectsAgentEntityTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2EntityType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}',
        http_method='GET',
        method_id='dialogflow.projects.agent.entityTypes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['languageCode'],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentEntityTypesGetRequest',
        response_type_name='GoogleCloudDialogflowV2EntityType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all entity types in the specified agent.

      Args:
        request: (DialogflowProjectsAgentEntityTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ListEntityTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes',
        http_method='GET',
        method_id='dialogflow.projects.agent.entityTypes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['languageCode', 'pageSize', 'pageToken'],
        relative_path='v2/{+parent}/entityTypes',
        request_field='',
        request_type_name='DialogflowProjectsAgentEntityTypesListRequest',
        response_type_name='GoogleCloudDialogflowV2ListEntityTypesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified entity type.

      Args:
        request: (DialogflowProjectsAgentEntityTypesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2EntityType) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}',
        http_method='PATCH',
        method_id='dialogflow.projects.agent.entityTypes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['languageCode', 'updateMask'],
        relative_path='v2/{+name}',
        request_field='googleCloudDialogflowV2EntityType',
        request_type_name='DialogflowProjectsAgentEntityTypesPatchRequest',
        response_type_name='GoogleCloudDialogflowV2EntityType',
        supports_download=False,
    )

  class ProjectsAgentEnvironmentsUsersSessionsContextsService(base_api.BaseApiService):
    """Service class for the projects_agent_environments_users_sessions_contexts resource."""

    _NAME = 'projects_agent_environments_users_sessions_contexts'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentEnvironmentsUsersSessionsContextsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a context.

If the specified context already exists, overrides the context.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsContextsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Context) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts',
        http_method='POST',
        method_id='dialogflow.projects.agent.environments.users.sessions.contexts.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/contexts',
        request_field='googleCloudDialogflowV2Context',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsContextsCreateRequest',
        response_type_name='GoogleCloudDialogflowV2Context',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified context.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsContextsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts/{contextsId}',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.environments.users.sessions.contexts.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsContextsDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified context.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsContextsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Context) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts/{contextsId}',
        http_method='GET',
        method_id='dialogflow.projects.agent.environments.users.sessions.contexts.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsContextsGetRequest',
        response_type_name='GoogleCloudDialogflowV2Context',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all contexts in the specified session.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsContextsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ListContextsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts',
        http_method='GET',
        method_id='dialogflow.projects.agent.environments.users.sessions.contexts.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/contexts',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsContextsListRequest',
        response_type_name='GoogleCloudDialogflowV2ListContextsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified context.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsContextsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Context) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts/{contextsId}',
        http_method='PATCH',
        method_id='dialogflow.projects.agent.environments.users.sessions.contexts.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='googleCloudDialogflowV2Context',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsContextsPatchRequest',
        response_type_name='GoogleCloudDialogflowV2Context',
        supports_download=False,
    )

  class ProjectsAgentEnvironmentsUsersSessionsEntityTypesService(base_api.BaseApiService):
    """Service class for the projects_agent_environments_users_sessions_entityTypes resource."""

    _NAME = 'projects_agent_environments_users_sessions_entityTypes'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentEnvironmentsUsersSessionsEntityTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a session entity type.

If the specified session entity type already exists, overrides the session
entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2SessionEntityType) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes',
        http_method='POST',
        method_id='dialogflow.projects.agent.environments.users.sessions.entityTypes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/entityTypes',
        request_field='googleCloudDialogflowV2SessionEntityType',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesCreateRequest',
        response_type_name='GoogleCloudDialogflowV2SessionEntityType',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified session entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes/{entityTypesId}',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.environments.users.sessions.entityTypes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified session entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2SessionEntityType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes/{entityTypesId}',
        http_method='GET',
        method_id='dialogflow.projects.agent.environments.users.sessions.entityTypes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesGetRequest',
        response_type_name='GoogleCloudDialogflowV2SessionEntityType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all session entity types in the specified session.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ListSessionEntityTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes',
        http_method='GET',
        method_id='dialogflow.projects.agent.environments.users.sessions.entityTypes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/entityTypes',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesListRequest',
        response_type_name='GoogleCloudDialogflowV2ListSessionEntityTypesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified session entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2SessionEntityType) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes/{entityTypesId}',
        http_method='PATCH',
        method_id='dialogflow.projects.agent.environments.users.sessions.entityTypes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='googleCloudDialogflowV2SessionEntityType',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsEntityTypesPatchRequest',
        response_type_name='GoogleCloudDialogflowV2SessionEntityType',
        supports_download=False,
    )

  class ProjectsAgentEnvironmentsUsersSessionsService(base_api.BaseApiService):
    """Service class for the projects_agent_environments_users_sessions resource."""

    _NAME = 'projects_agent_environments_users_sessions'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentEnvironmentsUsersSessionsService, self).__init__(client)
      self._upload_configs = {
          }

    def DeleteContexts(self, request, global_params=None):
      r"""Deletes all active contexts in the specified session.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsDeleteContextsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('DeleteContexts')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteContexts.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.environments.users.sessions.deleteContexts',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/contexts',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsDeleteContextsRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def DetectIntent(self, request, global_params=None):
      r"""Processes a natural language query and returns structured, actionable data.
as a result. This method is not idempotent, because it may cause contexts
and session entity types to be updated, which in turn might affect
results of future queries.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsUsersSessionsDetectIntentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2DetectIntentResponse) The response message.
      """
      config = self.GetMethodConfig('DetectIntent')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetectIntent.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}:detectIntent',
        http_method='POST',
        method_id='dialogflow.projects.agent.environments.users.sessions.detectIntent',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v2/{+session}:detectIntent',
        request_field='googleCloudDialogflowV2DetectIntentRequest',
        request_type_name='DialogflowProjectsAgentEnvironmentsUsersSessionsDetectIntentRequest',
        response_type_name='GoogleCloudDialogflowV2DetectIntentResponse',
        supports_download=False,
    )

  class ProjectsAgentEnvironmentsUsersService(base_api.BaseApiService):
    """Service class for the projects_agent_environments_users resource."""

    _NAME = 'projects_agent_environments_users'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentEnvironmentsUsersService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsAgentEnvironmentsService(base_api.BaseApiService):
    """Service class for the projects_agent_environments resource."""

    _NAME = 'projects_agent_environments'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentEnvironmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns the list of all non-draft environments of the specified agent.

      Args:
        request: (DialogflowProjectsAgentEnvironmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ListEnvironmentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/environments',
        http_method='GET',
        method_id='dialogflow.projects.agent.environments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/environments',
        request_field='',
        request_type_name='DialogflowProjectsAgentEnvironmentsListRequest',
        response_type_name='GoogleCloudDialogflowV2ListEnvironmentsResponse',
        supports_download=False,
    )

  class ProjectsAgentIntentsService(base_api.BaseApiService):
    """Service class for the projects_agent_intents resource."""

    _NAME = 'projects_agent_intents'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentIntentsService, self).__init__(client)
      self._upload_configs = {
          }

    def BatchDelete(self, request, global_params=None):
      r"""Deletes intents in the specified agent.

Operation <response: google.protobuf.Empty>

      Args:
        request: (DialogflowProjectsAgentIntentsBatchDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('BatchDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/intents:batchDelete',
        http_method='POST',
        method_id='dialogflow.projects.agent.intents.batchDelete',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/intents:batchDelete',
        request_field='googleCloudDialogflowV2BatchDeleteIntentsRequest',
        request_type_name='DialogflowProjectsAgentIntentsBatchDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def BatchUpdate(self, request, global_params=None):
      r"""Updates/Creates multiple intents in the specified agent.

Operation <response: BatchUpdateIntentsResponse>

      Args:
        request: (DialogflowProjectsAgentIntentsBatchUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('BatchUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/intents:batchUpdate',
        http_method='POST',
        method_id='dialogflow.projects.agent.intents.batchUpdate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/intents:batchUpdate',
        request_field='googleCloudDialogflowV2BatchUpdateIntentsRequest',
        request_type_name='DialogflowProjectsAgentIntentsBatchUpdateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates an intent in the specified agent.

      Args:
        request: (DialogflowProjectsAgentIntentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Intent) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/intents',
        http_method='POST',
        method_id='dialogflow.projects.agent.intents.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['intentView', 'languageCode'],
        relative_path='v2/{+parent}/intents',
        request_field='googleCloudDialogflowV2Intent',
        request_type_name='DialogflowProjectsAgentIntentsCreateRequest',
        response_type_name='GoogleCloudDialogflowV2Intent',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified intent and its direct or indirect followup intents.

      Args:
        request: (DialogflowProjectsAgentIntentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/intents/{intentsId}',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.intents.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentIntentsDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified intent.

      Args:
        request: (DialogflowProjectsAgentIntentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Intent) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/intents/{intentsId}',
        http_method='GET',
        method_id='dialogflow.projects.agent.intents.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['intentView', 'languageCode'],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentIntentsGetRequest',
        response_type_name='GoogleCloudDialogflowV2Intent',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all intents in the specified agent.

      Args:
        request: (DialogflowProjectsAgentIntentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ListIntentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/intents',
        http_method='GET',
        method_id='dialogflow.projects.agent.intents.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['intentView', 'languageCode', 'pageSize', 'pageToken'],
        relative_path='v2/{+parent}/intents',
        request_field='',
        request_type_name='DialogflowProjectsAgentIntentsListRequest',
        response_type_name='GoogleCloudDialogflowV2ListIntentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified intent.

      Args:
        request: (DialogflowProjectsAgentIntentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Intent) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/intents/{intentsId}',
        http_method='PATCH',
        method_id='dialogflow.projects.agent.intents.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['intentView', 'languageCode', 'updateMask'],
        relative_path='v2/{+name}',
        request_field='googleCloudDialogflowV2Intent',
        request_type_name='DialogflowProjectsAgentIntentsPatchRequest',
        response_type_name='GoogleCloudDialogflowV2Intent',
        supports_download=False,
    )

  class ProjectsAgentSessionsContextsService(base_api.BaseApiService):
    """Service class for the projects_agent_sessions_contexts resource."""

    _NAME = 'projects_agent_sessions_contexts'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentSessionsContextsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a context.

If the specified context already exists, overrides the context.

      Args:
        request: (DialogflowProjectsAgentSessionsContextsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Context) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts',
        http_method='POST',
        method_id='dialogflow.projects.agent.sessions.contexts.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/contexts',
        request_field='googleCloudDialogflowV2Context',
        request_type_name='DialogflowProjectsAgentSessionsContextsCreateRequest',
        response_type_name='GoogleCloudDialogflowV2Context',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified context.

      Args:
        request: (DialogflowProjectsAgentSessionsContextsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.sessions.contexts.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentSessionsContextsDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified context.

      Args:
        request: (DialogflowProjectsAgentSessionsContextsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Context) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}',
        http_method='GET',
        method_id='dialogflow.projects.agent.sessions.contexts.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentSessionsContextsGetRequest',
        response_type_name='GoogleCloudDialogflowV2Context',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all contexts in the specified session.

      Args:
        request: (DialogflowProjectsAgentSessionsContextsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ListContextsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts',
        http_method='GET',
        method_id='dialogflow.projects.agent.sessions.contexts.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/contexts',
        request_field='',
        request_type_name='DialogflowProjectsAgentSessionsContextsListRequest',
        response_type_name='GoogleCloudDialogflowV2ListContextsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified context.

      Args:
        request: (DialogflowProjectsAgentSessionsContextsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Context) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}',
        http_method='PATCH',
        method_id='dialogflow.projects.agent.sessions.contexts.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='googleCloudDialogflowV2Context',
        request_type_name='DialogflowProjectsAgentSessionsContextsPatchRequest',
        response_type_name='GoogleCloudDialogflowV2Context',
        supports_download=False,
    )

  class ProjectsAgentSessionsEntityTypesService(base_api.BaseApiService):
    """Service class for the projects_agent_sessions_entityTypes resource."""

    _NAME = 'projects_agent_sessions_entityTypes'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentSessionsEntityTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a session entity type.

If the specified session entity type already exists, overrides the session
entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentSessionsEntityTypesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2SessionEntityType) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes',
        http_method='POST',
        method_id='dialogflow.projects.agent.sessions.entityTypes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/entityTypes',
        request_field='googleCloudDialogflowV2SessionEntityType',
        request_type_name='DialogflowProjectsAgentSessionsEntityTypesCreateRequest',
        response_type_name='GoogleCloudDialogflowV2SessionEntityType',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified session entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentSessionsEntityTypesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.sessions.entityTypes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentSessionsEntityTypesDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified session entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentSessionsEntityTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2SessionEntityType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}',
        http_method='GET',
        method_id='dialogflow.projects.agent.sessions.entityTypes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentSessionsEntityTypesGetRequest',
        response_type_name='GoogleCloudDialogflowV2SessionEntityType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all session entity types in the specified session.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentSessionsEntityTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ListSessionEntityTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes',
        http_method='GET',
        method_id='dialogflow.projects.agent.sessions.entityTypes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/entityTypes',
        request_field='',
        request_type_name='DialogflowProjectsAgentSessionsEntityTypesListRequest',
        response_type_name='GoogleCloudDialogflowV2ListSessionEntityTypesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified session entity type.

This method doesn't work with Google Assistant integration.
Contact Dialogflow support if you need to use session entities
with Google Assistant integration.

      Args:
        request: (DialogflowProjectsAgentSessionsEntityTypesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2SessionEntityType) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}',
        http_method='PATCH',
        method_id='dialogflow.projects.agent.sessions.entityTypes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='googleCloudDialogflowV2SessionEntityType',
        request_type_name='DialogflowProjectsAgentSessionsEntityTypesPatchRequest',
        response_type_name='GoogleCloudDialogflowV2SessionEntityType',
        supports_download=False,
    )

  class ProjectsAgentSessionsService(base_api.BaseApiService):
    """Service class for the projects_agent_sessions resource."""

    _NAME = 'projects_agent_sessions'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentSessionsService, self).__init__(client)
      self._upload_configs = {
          }

    def DeleteContexts(self, request, global_params=None):
      r"""Deletes all active contexts in the specified session.

      Args:
        request: (DialogflowProjectsAgentSessionsDeleteContextsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('DeleteContexts')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteContexts.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts',
        http_method='DELETE',
        method_id='dialogflow.projects.agent.sessions.deleteContexts',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/contexts',
        request_field='',
        request_type_name='DialogflowProjectsAgentSessionsDeleteContextsRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def DetectIntent(self, request, global_params=None):
      r"""Processes a natural language query and returns structured, actionable data.
as a result. This method is not idempotent, because it may cause contexts
and session entity types to be updated, which in turn might affect
results of future queries.

      Args:
        request: (DialogflowProjectsAgentSessionsDetectIntentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2DetectIntentResponse) The response message.
      """
      config = self.GetMethodConfig('DetectIntent')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetectIntent.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/sessions/{sessionsId}:detectIntent',
        http_method='POST',
        method_id='dialogflow.projects.agent.sessions.detectIntent',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v2/{+session}:detectIntent',
        request_field='googleCloudDialogflowV2DetectIntentRequest',
        request_type_name='DialogflowProjectsAgentSessionsDetectIntentRequest',
        response_type_name='GoogleCloudDialogflowV2DetectIntentResponse',
        supports_download=False,
    )

  class ProjectsAgentService(base_api.BaseApiService):
    """Service class for the projects_agent resource."""

    _NAME = 'projects_agent'

    def __init__(self, client):
      super(DialogflowV2.ProjectsAgentService, self).__init__(client)
      self._upload_configs = {
          }

    def Export(self, request, global_params=None):
      r"""Exports the specified agent to a ZIP file.

Operation <response: ExportAgentResponse>

      Args:
        request: (DialogflowProjectsAgentExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent:export',
        http_method='POST',
        method_id='dialogflow.projects.agent.export',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/agent:export',
        request_field='googleCloudDialogflowV2ExportAgentRequest',
        request_type_name='DialogflowProjectsAgentExportRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def GetFulfillment(self, request, global_params=None):
      r"""Retrieves the fulfillment.

      Args:
        request: (DialogflowProjectsAgentGetFulfillmentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Fulfillment) The response message.
      """
      config = self.GetMethodConfig('GetFulfillment')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetFulfillment.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/fulfillment',
        http_method='GET',
        method_id='dialogflow.projects.agent.getFulfillment',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsAgentGetFulfillmentRequest',
        response_type_name='GoogleCloudDialogflowV2Fulfillment',
        supports_download=False,
    )

    def GetValidationResult(self, request, global_params=None):
      r"""Gets agent validation result. Agent validation is performed during.
training time and is updated automatically when training is completed.

      Args:
        request: (DialogflowProjectsAgentGetValidationResultRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2ValidationResult) The response message.
      """
      config = self.GetMethodConfig('GetValidationResult')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetValidationResult.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/validationResult',
        http_method='GET',
        method_id='dialogflow.projects.agent.getValidationResult',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['languageCode'],
        relative_path='v2/{+parent}/agent/validationResult',
        request_field='',
        request_type_name='DialogflowProjectsAgentGetValidationResultRequest',
        response_type_name='GoogleCloudDialogflowV2ValidationResult',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Imports the specified agent from a ZIP file.

Uploads new intents and entity types without deleting the existing ones.
Intents and entity types with the same name are replaced with the new
versions from ImportAgentRequest. After the import, the imported draft
agent will be trained automatically (unless disabled in agent settings).
However, once the import is done, training may not be completed yet. Please
call TrainAgent and wait for the operation it returns in order to train
explicitly.

Operation <response: google.protobuf.Empty>
An operation which tracks when importing is complete. It only tracks
when the draft agent is updated not when it is done training.

      Args:
        request: (DialogflowProjectsAgentImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent:import',
        http_method='POST',
        method_id='dialogflow.projects.agent.import',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/agent:import',
        request_field='googleCloudDialogflowV2ImportAgentRequest',
        request_type_name='DialogflowProjectsAgentImportRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Restore(self, request, global_params=None):
      r"""Restores the specified agent from a ZIP file.

Replaces the current agent version with a new one. All the intents and
entity types in the older version are deleted. After the restore, the
restored draft agent will be trained automatically (unless disabled in
agent settings). However, once the restore is done, training may not be
completed yet. Please call TrainAgent and wait for the operation it
returns in order to train explicitly.

Operation <response: google.protobuf.Empty>
An operation which tracks when restoring is complete. It only tracks
when the draft agent is updated not when it is done training.

      Args:
        request: (DialogflowProjectsAgentRestoreRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Restore')
      return self._RunMethod(
          config, request, global_params=global_params)

    Restore.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent:restore',
        http_method='POST',
        method_id='dialogflow.projects.agent.restore',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/agent:restore',
        request_field='googleCloudDialogflowV2RestoreAgentRequest',
        request_type_name='DialogflowProjectsAgentRestoreRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Returns the list of agents.

Since there is at most one conversational agent per project, this method is
useful primarily for listing all agents across projects the caller has
access to. One can achieve that with a wildcard project collection id "-".
Refer to [List
Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).

      Args:
        request: (DialogflowProjectsAgentSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2SearchAgentsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent:search',
        http_method='GET',
        method_id='dialogflow.projects.agent.search',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/agent:search',
        request_field='',
        request_type_name='DialogflowProjectsAgentSearchRequest',
        response_type_name='GoogleCloudDialogflowV2SearchAgentsResponse',
        supports_download=False,
    )

    def Train(self, request, global_params=None):
      r"""Trains the specified agent.

Operation <response: google.protobuf.Empty>

      Args:
        request: (DialogflowProjectsAgentTrainRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Train')
      return self._RunMethod(
          config, request, global_params=global_params)

    Train.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent:train',
        http_method='POST',
        method_id='dialogflow.projects.agent.train',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/agent:train',
        request_field='googleCloudDialogflowV2TrainAgentRequest',
        request_type_name='DialogflowProjectsAgentTrainRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def UpdateFulfillment(self, request, global_params=None):
      r"""Updates the fulfillment.

      Args:
        request: (DialogflowProjectsAgentUpdateFulfillmentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Fulfillment) The response message.
      """
      config = self.GetMethodConfig('UpdateFulfillment')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateFulfillment.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent/fulfillment',
        http_method='PATCH',
        method_id='dialogflow.projects.agent.updateFulfillment',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='googleCloudDialogflowV2Fulfillment',
        request_type_name='DialogflowProjectsAgentUpdateFulfillmentRequest',
        response_type_name='GoogleCloudDialogflowV2Fulfillment',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(DialogflowV2.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (DialogflowProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='dialogflow.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:cancel',
        request_field='',
        request_type_name='DialogflowProjectsLocationsOperationsCancelRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (DialogflowProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='dialogflow.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsLocationsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (DialogflowProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='dialogflow.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2/{+name}/operations',
        request_field='',
        request_type_name='DialogflowProjectsLocationsOperationsListRequest',
        response_type_name='GoogleLongrunningListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(DialogflowV2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsOperationsService(base_api.BaseApiService):
    """Service class for the projects_operations resource."""

    _NAME = 'projects_operations'

    def __init__(self, client):
      super(DialogflowV2.ProjectsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (DialogflowProjectsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='dialogflow.projects.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:cancel',
        request_field='',
        request_type_name='DialogflowProjectsOperationsCancelRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (DialogflowProjectsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/operations/{operationsId}',
        http_method='GET',
        method_id='dialogflow.projects.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='DialogflowProjectsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (DialogflowProjectsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/operations',
        http_method='GET',
        method_id='dialogflow.projects.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2/{+name}/operations',
        request_field='',
        request_type_name='DialogflowProjectsOperationsListRequest',
        response_type_name='GoogleLongrunningListOperationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(DialogflowV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def DeleteAgent(self, request, global_params=None):
      r"""Deletes the specified agent.

      Args:
        request: (DialogflowProjectsDeleteAgentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('DeleteAgent')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAgent.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent',
        http_method='DELETE',
        method_id='dialogflow.projects.deleteAgent',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/agent',
        request_field='',
        request_type_name='DialogflowProjectsDeleteAgentRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def GetAgent(self, request, global_params=None):
      r"""Retrieves the specified agent.

      Args:
        request: (DialogflowProjectsGetAgentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Agent) The response message.
      """
      config = self.GetMethodConfig('GetAgent')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAgent.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent',
        http_method='GET',
        method_id='dialogflow.projects.getAgent',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/agent',
        request_field='',
        request_type_name='DialogflowProjectsGetAgentRequest',
        response_type_name='GoogleCloudDialogflowV2Agent',
        supports_download=False,
    )

    def SetAgent(self, request, global_params=None):
      r"""Creates/updates the specified agent.

      Args:
        request: (DialogflowProjectsSetAgentRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudDialogflowV2Agent) The response message.
      """
      config = self.GetMethodConfig('SetAgent')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAgent.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/agent',
        http_method='POST',
        method_id='dialogflow.projects.setAgent',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['updateMask'],
        relative_path='v2/{+parent}/agent',
        request_field='googleCloudDialogflowV2Agent',
        request_type_name='DialogflowProjectsSetAgentRequest',
        response_type_name='GoogleCloudDialogflowV2Agent',
        supports_download=False,
    )
