"""Generated client library for edge version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.edge.v1alpha1 import edge_v1alpha1_messages as messages


class EdgeV1alpha1(base_api.BaseApiClient):
  """Generated client library for service edge version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://edge.googleapis.com/'

  _PACKAGE = u'edge'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloudiot', u'https://www.googleapis.com/auth/devstorage.read_write']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'EdgeV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new edge handle."""
    url = url or self.BASE_URL
    super(EdgeV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_registries_devices_containers = self.ProjectsLocationsRegistriesDevicesContainersService(self)
    self.projects_locations_registries_devices_functions = self.ProjectsLocationsRegistriesDevicesFunctionsService(self)
    self.projects_locations_registries_devices_mlModels = self.ProjectsLocationsRegistriesDevicesMlModelsService(self)
    self.projects_locations_registries_devices = self.ProjectsLocationsRegistriesDevicesService(self)
    self.projects_locations_registries = self.ProjectsLocationsRegistriesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsRegistriesDevicesContainersService(base_api.BaseApiService):
    """Service class for the projects_locations_registries_devices_containers resource."""

    _NAME = u'projects_locations_registries_devices_containers'

    def __init__(self, client):
      super(EdgeV1alpha1.ProjectsLocationsRegistriesDevicesContainersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new edge container.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesContainersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Container) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/containers',
        http_method=u'POST',
        method_id=u'edge.projects.locations.registries.devices.containers.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/containers',
        request_field=u'container',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesContainersCreateRequest',
        response_type_name=u'Container',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a container. This method is idempotent in effect, but it will.
result in a `google.rpc.Code.NOT_FOUND` error for subsequent requests after
the first successful deletion.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesContainersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/containers/{containersId}',
        http_method=u'DELETE',
        method_id=u'edge.projects.locations.registries.devices.containers.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesContainersDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the detail of the container.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesContainersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Container) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/containers/{containersId}',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.containers.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesContainersGetRequest',
        response_type_name=u'Container',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of containers registered on the device.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesContainersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListContainersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/containers',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.containers.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'fieldMask', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/containers',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesContainersListRequest',
        response_type_name=u'ListContainersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing new user container.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesContainersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Container) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/containers/{containersId}',
        http_method=u'PATCH',
        method_id=u'edge.projects.locations.registries.devices.containers.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'container',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesContainersPatchRequest',
        response_type_name=u'Container',
        supports_download=False,
    )

  class ProjectsLocationsRegistriesDevicesFunctionsService(base_api.BaseApiService):
    """Service class for the projects_locations_registries_devices_functions resource."""

    _NAME = u'projects_locations_registries_devices_functions'

    def __init__(self, client):
      super(EdgeV1alpha1.ProjectsLocationsRegistriesDevicesFunctionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new edge function.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesFunctionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Function) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/functions',
        http_method=u'POST',
        method_id=u'edge.projects.locations.registries.devices.functions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/functions',
        request_field=u'function',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesFunctionsCreateRequest',
        response_type_name=u'Function',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a function. This method is idempotent in effect, but it will result.
in a `google.rpc.Code.NOT_FOUND` error for subsequent requests after the
first successful deletion.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesFunctionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/functions/{functionsId}',
        http_method=u'DELETE',
        method_id=u'edge.projects.locations.registries.devices.functions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesFunctionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the detail of the specified function.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesFunctionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Function) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/functions/{functionsId}',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.functions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesFunctionsGetRequest',
        response_type_name=u'Function',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of functions running on the device.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesFunctionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFunctionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/functions',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.functions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'fieldMask', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/functions',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesFunctionsListRequest',
        response_type_name=u'ListFunctionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing function.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesFunctionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Function) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/functions/{functionsId}',
        http_method=u'PATCH',
        method_id=u'edge.projects.locations.registries.devices.functions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'function',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesFunctionsPatchRequest',
        response_type_name=u'Function',
        supports_download=False,
    )

  class ProjectsLocationsRegistriesDevicesMlModelsService(base_api.BaseApiService):
    """Service class for the projects_locations_registries_devices_mlModels resource."""

    _NAME = u'projects_locations_registries_devices_mlModels'

    def __init__(self, client):
      super(EdgeV1alpha1.ProjectsLocationsRegistriesDevicesMlModelsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ML model. An ML model is a TensorFlow Lite model, that will.
be deployed and run on edge devices.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesMlModelsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MlModel) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/mlModels',
        http_method=u'POST',
        method_id=u'edge.projects.locations.registries.devices.mlModels.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/mlModels',
        request_field=u'mlModel',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesMlModelsCreateRequest',
        response_type_name=u'MlModel',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing ML Model. This method is idempotent in effect, but it.
will result in a `google.rpc.Code.NOT_FOUND` error for subsequent requests
after the first successful deletion.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesMlModelsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/mlModels/{mlModelsId}',
        http_method=u'DELETE',
        method_id=u'edge.projects.locations.registries.devices.mlModels.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesMlModelsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the detail of an ML model.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesMlModelsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MlModel) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/mlModels/{mlModelsId}',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.mlModels.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesMlModelsGetRequest',
        response_type_name=u'MlModel',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of ML models attached to the device.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesMlModelsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMlModelsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/mlModels',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.mlModels.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'fieldMask', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/mlModels',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesMlModelsListRequest',
        response_type_name=u'ListMlModelsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing ML Model.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesMlModelsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MlModel) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/mlModels/{mlModelsId}',
        http_method=u'PATCH',
        method_id=u'edge.projects.locations.registries.devices.mlModels.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'mlModel',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesMlModelsPatchRequest',
        response_type_name=u'MlModel',
        supports_download=False,
    )

  class ProjectsLocationsRegistriesDevicesService(base_api.BaseApiService):
    """Service class for the projects_locations_registries_devices resource."""

    _NAME = u'projects_locations_registries_devices'

    def __init__(self, client):
      super(EdgeV1alpha1.ProjectsLocationsRegistriesDevicesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetState(self, request, global_params=None):
      r"""Returns the latest user state of the device.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesGetStateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EdgeState) The response message.
      """
      config = self.GetMethodConfig('GetState')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetState.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/state',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.getState',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'fieldMask'],
        relative_path=u'v1alpha1/{+name}/state',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesGetStateRequest',
        response_type_name=u'EdgeState',
        supports_download=False,
    )

    def GetTopicBridgingTable(self, request, global_params=None):
      r"""Returns the entire topic bridging table of an edge device. Topic bridging.
table is singleton per device.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesGetTopicBridgingTableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TopicBridgingTable) The response message.
      """
      config = self.GetMethodConfig('GetTopicBridgingTable')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetTopicBridgingTable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/topicBridgingTable',
        http_method=u'GET',
        method_id=u'edge.projects.locations.registries.devices.getTopicBridgingTable',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}/topicBridgingTable',
        request_field='',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesGetTopicBridgingTableRequest',
        response_type_name=u'TopicBridgingTable',
        supports_download=False,
    )

    def Init(self, request, global_params=None):
      r"""Initializes an existing device as an edge device.

      Args:
        request: (EdgeProjectsLocationsRegistriesDevicesInitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Init')
      return self._RunMethod(
          config, request, global_params=global_params)

    Init.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}:init',
        http_method=u'POST',
        method_id=u'edge.projects.locations.registries.devices.init',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}:init',
        request_field=u'initAsEdgeDeviceRequest',
        request_type_name=u'EdgeProjectsLocationsRegistriesDevicesInitRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def UpdateTopicBridgingTable(self, request, global_params=None):
      r"""Updates topic bridging table of an edge device. Partial update for topic.
bridging table is not supported.

      Args:
        request: (TopicBridgingTable) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TopicBridgingTable) The response message.
      """
      config = self.GetMethodConfig('UpdateTopicBridgingTable')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateTopicBridgingTable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/topicBridgingTable',
        http_method=u'PUT',
        method_id=u'edge.projects.locations.registries.devices.updateTopicBridgingTable',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}/topicBridgingTable',
        request_field='<request>',
        request_type_name=u'TopicBridgingTable',
        response_type_name=u'TopicBridgingTable',
        supports_download=False,
    )

  class ProjectsLocationsRegistriesService(base_api.BaseApiService):
    """Service class for the projects_locations_registries resource."""

    _NAME = u'projects_locations_registries'

    def __init__(self, client):
      super(EdgeV1alpha1.ProjectsLocationsRegistriesService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(EdgeV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(EdgeV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
