require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_PROFILE_H_)) {
    eval 'sub _MACHINE_PROFILE_H_ () {1;}' unless defined(&_MACHINE_PROFILE_H_);
    unless(defined(&_SYS_CDEFS_H_)) {
	die("this\ file\ needs\ sys\/cdefs\.h\ as\ a\ prerequisite");
    }
    if(defined(&_KERNEL)) {
	eval 'sub FUNCTION_ALIGNMENT () {16;}' unless defined(&FUNCTION_ALIGNMENT);
	eval 'sub _MCOUNT_DECL () { &void  &mcount;}' unless defined(&_MCOUNT_DECL);
	eval 'sub MCOUNT () {1;}' unless defined(&MCOUNT);
	if(defined(&GUPROF)) {
	    eval 'sub MCOUNT_DECL {
	        my($s) = @_;
    		eval q();
	    }' unless defined(&MCOUNT_DECL);
	    eval 'sub MCOUNT_ENTER {
	        my($s) = @_;
    		eval q();
	    }' unless defined(&MCOUNT_ENTER);
	    eval 'sub MCOUNT_EXIT {
	        my($s) = @_;
    		eval q();
	    }' unless defined(&MCOUNT_EXIT);
	    if(defined(&__GNUCLIKE_ASM)) {
		eval 'sub MCOUNT_OVERHEAD {
		    my($label) = @_;
    		    eval q( &__asm  &__volatile(\\"pushl %0; call __mcount; popl %%ecx\\" : : \\"i\\" ($label) : \\"ax\\", \\"dx\\", \\"cx\\", \\"memory\\"));
		}' unless defined(&MCOUNT_OVERHEAD);
		eval 'sub MEXITCOUNT_OVERHEAD () {
		    eval q( &__asm  &__volatile(\\"call .mexitcount; 1:\\" : : : \\"ax\\", \\"dx\\", \\"cx\\", \\"memory\\"));
		}' unless defined(&MEXITCOUNT_OVERHEAD);
		eval 'sub MEXITCOUNT_OVERHEAD_GETLABEL {
		    my($labelp) = @_;
    		    eval q( &__asm  &__volatile(\\"movl $1b,%0\\" : \\"=rm\\" ($labelp)));
		}' unless defined(&MEXITCOUNT_OVERHEAD_GETLABEL);
	    }
 elsif(defined(&lint)) {
		eval 'sub MCOUNT_OVERHEAD {
		    my($label) = @_;
    		    eval q();
		}' unless defined(&MCOUNT_OVERHEAD);
		eval 'sub MEXITCOUNT_OVERHEAD () {
		    eval q();
		}' unless defined(&MEXITCOUNT_OVERHEAD);
		eval 'sub MEXITCOUNT_OVERHEAD_GETLABEL () {
		    eval q();
		}' unless defined(&MEXITCOUNT_OVERHEAD_GETLABEL);
	    } else {
	    }
	} else {
	    eval 'sub MCOUNT_DECL {
	        my($s) = @_;
    		eval q( &register_t $s;);
	    }' unless defined(&MCOUNT_DECL);
	    if(defined(&SMP)) {
		eval 'sub MCOUNT_ENTER {
		    my($s) = @_;
    		    eval q({ $s =  &intr_disable();  &while (! &atomic_cmpset_acq_int( &mcount_lock, 0, 1)) ; });
		}' unless defined(&MCOUNT_ENTER);
		eval 'sub MCOUNT_EXIT {
		    my($s) = @_;
    		    eval q({  &atomic_store_rel_int( &mcount_lock, 0);  &intr_restore($s); });
		}' unless defined(&MCOUNT_EXIT);
	    } else {
		eval 'sub MCOUNT_ENTER {
		    my($s) = @_;
    		    eval q({ $s =  &intr_disable(); });
		}' unless defined(&MCOUNT_ENTER);
		eval 'sub MCOUNT_EXIT {
		    my($s) = @_;
    		    eval q(( &intr_restore($s)));
		}' unless defined(&MCOUNT_EXIT);
	    }
	}
	eval 'sub MCOUNT_FROMPC_USER {
	    my($pc) = @_;
    	    eval q((($pc < ( &uintfptr_t) &VM_MAXUSER_ADDRESS) ? ( &uintfptr_t) &user : $pc));
	}' unless defined(&MCOUNT_FROMPC_USER);
	eval 'sub MCOUNT_FROMPC_INTR {
	    my($pc) = @_;
    	    eval q((($pc >= ( &uintfptr_t) &btrap  && $pc < ( &uintfptr_t) &eintr) ? (($pc >= ( &uintfptr_t) &bintr) ? ( &uintfptr_t) &bintr : ( &uintfptr_t) &btrap) : ~0));
	}' unless defined(&MCOUNT_FROMPC_INTR);
    } else {
	eval 'sub FUNCTION_ALIGNMENT () {4;}' unless defined(&FUNCTION_ALIGNMENT);
	eval 'sub _MCOUNT_DECL () { &static  &__inline  &void  &_mcount;}' unless defined(&_MCOUNT_DECL);
	if(defined(&__GNUCLIKE_ASM)) {
	    eval 'sub MCOUNT () { &void  &mcount() {  &uintfptr_t  &selfpc,  &frompc,  &ecx;  &__asm("" : "=c" ( &ecx));  &__asm("movl 4(%%ebp),%0" : "=r" ( &selfpc));  &__asm("movl (%%ebp),%0" : "=r" ( &frompc));  &frompc = (( &uintfptr_t *) &frompc)[1];  &_mcount( &frompc,  &selfpc);  &__asm("" : : "c" ( &ecx)); };}' unless defined(&MCOUNT);
	} else {
	    eval 'sub MCOUNT () {1;}' unless defined(&MCOUNT);
	}
    }
    if(defined(&_KERNEL)) {
    } else {
	require 'sys/cdefs.ph';
	if(defined(&__GNUCLIKE_ASM)) {
	}
    }
}
1;
